with open('slovar_ljudi.txt', 'r') as datoteka:
    slovar_ljudi = {}
    for vrstica in datoteka:
        podatki = vrstica.split(' ')
        slovar_ljudi[podatki[0]] = (int(podatki[1]), podatki[2], podatki[3][:-1])


# Slovar ni urejena struktura. Ce hocemo urejeno strukturo, moramo slovar prepisati
# v seznam. To najlazje storimo tako, da so elementi seznama pari. Prvi element seznama
# je kljuc, drugi element pa pripadajoca vrednost.
def uredi_po_kljucih(slovar):
    seznam = []
    for kljuc in slovar:
        seznam.append((kljuc, slovar[kljuc]))
    # sorted() ureja leksikografsko. Ce jo poklicemo na tem seznamu, ga bo uredila po
    # kljucih, ker so ti prvi elementi parov. Ce bi dva kljuca bila enaka (kar se ne more
    # zgoditi), bi sroted() elementa uredila po drugih elementih para.
    return sorted(seznam)

def uredi_po_vrednostih(slovar):
    seznam = []
    for kljuc in slovar:
        # Ker hocemo seznam sedaj urediti po vrednostih, vlogo kljucev in vrednosti
        # zamenjamo. Funkcija sorted() bo sedaj seznam uredila po vrednostih in ne kljucih.
        seznam.append((slovar[kljuc], kljuc))
    return sorted(seznam)

# Potrebovali bomo slovar, katerega kljuci bodo leta, vrednosti pa stevilo ljudi,
# rojenih tega leta. Ker bomo potrebovali n-ti najvecjo vrednost, lahko stevilo
# ljudi stejemo negativno. Kako to pomaga, je razlozeno v naslednjem komentarju.
def prestej_leta(slovar_ljudi):
    slovar_letnikov = {}
    for kljuc in slovar_ljudi:
        letnik = slovar_ljudi[kljuc][0]
        if letnik not in slovar_letnikov:
            slovar_letnikov[letnik] = -1
        else:
            slovar_letnikov[letnik] -= 1
    return slovar_letnikov

slovar_letnikov = prestej_leta(slovar_ljudi)

# Letnik oceta je kljuc s 126. najvecjo vrednostjo. Ker so vrednosti v slovarju negativne,
# je "najvecja" vrednost v resnci najmanjsa. Najstevilcnejsa generacija je tako prva
# v seznamu, ne zadnja. Ker sezname stevilcimo od 0 dalje, iscemo element z indeksom 125.
# Ce bi vrednosti v izvornem slovarju bile pozitivne, bi iskali element z indeksom
# len(slovar_letnikov) - 126.
urejeni_seznam_letnikov = uredi_po_vrednostih(slovar_letnikov)
# Ker je seznam urejen po vrednostih slovarja, so leta, ki so kljuci slovarja, drugi
# elementi parov (prvi elementi so stevila ljudi, rojenih v teh letih).
# Skrito privzamemo, da si generacija oceta svoje stevilcnosti ne deli z nobeno drugo.
letnik_oceta = urejeni_seznam_letnikov[125][1]

# Da poiscemo letnik matere, uredimo leta po vrsti. Iscemo prva sosednja elementa seznama,
# ki se po letih razlikujeta za natanko 2. Iskano leto je drugi izmed sosedov.
urejeni_seznam_letnikov_2 = uredi_po_kljucih(slovar_letnikov)
indeks = 0
# Ker je seznam urejen po kljucih slovarja, so leta prvi elementi parov.
while urejeni_seznam_letnikov_2[indeks + 1][0] != urejeni_seznam_letnikov_2[indeks][0] + 3:
    indeks += 1
letnik_matere = urejeni_seznam_letnikov_2[indeks + 1][0]

### Se ena moznost, da poiscemo letnik matere: ###
# seznam_kljucev = list(slovar_ljudi.keys()).sort()
# indeks = 0
# while seznam_kljucev[indeks + 1] != seznam_kljucev[indeks] + 3:
#     indeks += 1
# letnik_matere = seznam_kljucev[indeks + 1]
### ###

for otrok in slovar_ljudi:
    leto = slovar_ljudi[otrok][0]
    mati = slovar_ljudi[otrok][1]
    oce = slovar_ljudi[otrok][2]
    # Oce in mati poljubnega cloveka nista nujno v slovarju.
    if mati in slovar_ljudi and oce in slovar_ljudi:
        if slovar_ljudi[oce][0] == 1914 and slovar_ljudi[mati][0] == 1918:
            print(otrok, leto)