# Preberemo podatke.
with open('mnozice.txt', 'r') as datoteka:
    vrstice = datoteka.readlines()
    seznam_zeljenih = vrstice[0].split(' ')
    seznam_primernih = vrstice[1].split(' ')
    seznam_pustolovscin = vrstice[2].split(' ')
    seznam_gotovo_ne = vrstice[3].split(' ')
    mnozica_zeljenih = set()
    mnozica_primernih = set()
    mnozica_pustolovscin = set()
    mnozica_gotovo_ne = set()
    for kraj in seznam_zeljenih:
        mnozica_zeljenih.add(kraj)
    for kraj in seznam_primernih:
        mnozica_primernih.add(kraj)
    for kraj in seznam_pustolovscin:
        mnozica_pustolovscin.add(kraj)
    for kraj in seznam_gotovo_ne:
        mnozica_gotovo_ne.add(kraj)


# Mozni kraji so vsi kraji, ki so v prvih dveh mnozicah hkrati ali pa v tretji mnozici, ne
# pa v cetrti. Torej: (A presek B unija C) \ D. Operacije se izvajajo od leve proti desni,
# zato dodatni oklepaji niso potrebni.
def mozni_kraji(mnozica_zeljenih, mnozica_primernih,
                mnozica_pustolovscin, mnozica_gotovo_ne):
    return mnozica_zeljenih.intersection(mnozica_primernih).union(
        mnozica_pustolovscin).difference(mnozica_gotovo_ne)

samoglasniki = 'aeiou'
soglasniki = 'bcdfghjklmnprstvz'

def razmerje_samoglasnikov_soglasnikov(beseda):
    stevilo_samoglasnikov = 0
    stevilo_soglasnikov = 0
    for crka in beseda:
        if crka in samoglasniki:
            stevilo_samoglasnikov += 1
        elif crka in soglasniki:
            stevilo_soglasnikov += 1
    if stevilo_soglasnikov == 0:
        # Ce je stevilo soglasnikov 0, moramo poskrbeti, da kraj s takim imenom
        # gotovo ne bo izbran. To lahko dosezemo recimo tako, da mu pripisemo
        # negativno razmerje.
        return -1
    return stevilo_samoglasnikov / stevilo_soglasnikov


mnozica_krajev = mozni_kraji(mnozica_zeljenih, mnozica_primernih,
                             mnozica_pustolovscin, mnozica_gotovo_ne)
# Z metodo pop() iz mnozice vzamemo poljuben element (ne vemo, katerega, ker v Pythonu
# mnozice ne belezijo vrstnega reda elementov; niti ni pomembno, kateri element dobimo)
# ter na njem izracunamo razmerje. Nato se zapeljemo cez vse (preostale) elemente
# mnozice in iscemo tistega z najvecjim takim razmerjem.
pravi_kraj = mnozica_krajev.pop()
staro_razmerje = razmerje_samoglasnikov_soglasnikov(pravi_kraj)
for kraj in mnozica_krajev:
    novo_razmerje = razmerje_samoglasnikov_soglasnikov(kraj)
    if novo_razmerje > staro_razmerje:
        pravi_kraj = kraj
        staro_razmerje = novo_razmerje
# Alternativno bi lahko namesto metode pop() na zacetku razmerje nastavili na -1, kar je
# gotovo manj od razmerja katerekoli ustrezne besede v mnozici.
print(pravi_kraj)