
/*
 * Najdaljše naraščajoče podzaporedje (LIS) v času O(n log n)
 */

#include <iostream>
#include <vector>

using namespace std;

// Izpiše LIS.
void izpisi(int i, const vector<int>& vhod, const vector<int>& predhodnik) {
    if (i != -1) {
        izpisi(predhodnik[i], vhod, predhodnik);
        cout << vhod[i] << " ";
    }
}

int main() {
    int n;
    cin >> n;
    vector<int> vhod(n);
    for (int i = 0;  i < n;  i++) {
        cin >> vhod[i];
    }

    // L[i]: najmanjši končni element med vsemi naraščajočimi zaporedji
    // dolžine i
    // (npr. če so [2, 5, 7], [2, 4, 6] in [2, 3, 9] vsa (doslej videna)
    // naraščajoča podzaporedja dolžine 3, je L[3] = min(7, 6, 9) = 6;
    // vektor L je vedno naraščajoče urejen, zato lahko na njem uporabljamo
    // dvojiško iskanje
    // POZOR: L != LIS
    vector<int> L(n);

    // L_indeks[i]: indeks elementa L[i] v vektorju <vhod>
    // (potrebujemo za rekonstrukcijo LIS)
    vector<int> L_indeks(n);

    // predhodnik[i]: indeks predhodnika elementa vhod[i] v vektorju <vhod>
    // (omogoča rekonstrukcijo LIS, če ga potrebujemo)
    vector<int> predhodnik(n, -1);

    // dolžina L (= dolžina LIS)
    int k = 0;

    // indeks zadnjega elementa LIS v vektorju <vhod>
    int indeksKonca = 0;

    for (int i = 0;  i < n;  i++) {
        // Če je vhod[i] večji od zadnjega elementa vektorja L,
        // smo trenutni LIS podaljšali za 1, sicer pa imamo boljšo (= manjšo)
        // končnico naraščajočega podzaporedja (IS) neke manjše dolžine.
        // Na primer, če je vhod = <3, 7, 5, 6, 2, 8>, se L spreminja takole:
        // i = 0: L = [3] (imamo LIS dolžine 1)
        // i = 1: L = [3, 7] (imamo LIS dolžine 2)
        // i = 2: L = [3, 5] (LIS je še vedno dolg 2, ampak 5 je boljša
        //        končnica kot 7)
        // i = 3: L = [3, 5, 6] (LIS je dolg 3; 1 je najboljša končnica za IS
        //        dolžine 1, 5 za IS dolžine 2, 6 pa za IS dolžine 3
        // i = 4: L = [2, 5, 6] (LIS je dolg 3; 2 je najboljša končnica za IS
        //        dolžine 1 ([2]), 5 za IS dolžine 2 ([3, 5]), 6 pa za IS
        //        dolžine 3 ([3, 5, 6])
        // i = 5: L = [2, 5, 6, 8] (LIS je dolg 4; s pomočjo vektorja
        //        <predhodnik> lahko sedaj rekonstruiramo dejanski LIS)

        int pozicija = lower_bound(L.begin(), L.begin() + k, vhod[i]) - L.begin();
        L[pozicija] = vhod[i];
        L_indeks[pozicija] = i;
        predhodnik[i] = (pozicija > 0) ? L_indeks[pozicija - 1] : -1;

        if (pozicija == k) {
            k = pozicija + 1;
            indeksKonca = i;
        }
    }

    cout << k << endl;

    // odkomentiramo, če potrebujemo tudi dejanski LIS
    /*
    izpisi(indeksKonca, vhod, predhodnik);
    cout << endl;
    */

    return 0;
}
