
/*
 * Urejevalna (Levenshteinova) razdalja
 */

#include <vector>
#include <string>
#include <iostream>

using namespace std;

// Vrne Levenshteinovo razdaljo med podnizoma a[0..ia] in b[0..ib].
// Če je memo[ia][ib] >= 0, potem memo[ia][ib] hrani že izračunano razdaljo za
// indeksa ia in ib.  Če je memo[ia][ib] == -1, razdalje še nismo izračunali.

int razdalja(const string& a, const string& b, int ia, int ib,
        vector<vector<int>>& memo) {

    // robna pogoja
    if (ib == 0) {
        return ia;
    }
    if (ia == 0) {
        return ib;
    }

    // Preverimo, ali smo vrednost funkcije za trenutni vrednosti parametrov
    // ia in ib že izračunali.  Če smo jo, jo preprosto vrnemo.
    if (memo[ia][ib] >= 0) {
        return memo[ia][ib];
    }

    // V nasprotnem primeru vrednost funkcije izračunamo in jo shranimo v
    // memoizacijsko tabelo.

    // zadnji znak podniza a[0..ia] je enak zadnjemu znaku podniza b[0..ib]
    if (a[ia - 1] == b[ib - 1]) {
        return memo[ia][ib] = razdalja(a, b, ia - 1, ib - 1, memo);
    }

    // zadnji znak podniza a[0..ia] je različen od prvega znaka podniza b[0..ib]
    int brisanje = razdalja(a, b, ia - 1, ib, memo);
    int vstavljanje = razdalja(a, b, ia, ib - 1, memo);
    int zamenjava = razdalja(a, b, ia - 1, ib - 1, memo);
    return memo[ia][ib] = 1 + min(brisanje, min(vstavljanje, zamenjava));
}

int main() {
    string a;
    string b;
    cin >> a >> b;

    int da = a.size();
    int db = b.size();

    vector<vector<int>> memo(da + 1, vector<int>(db + 1, -1));
    cout << razdalja(a, b, da, db, memo) << endl;

    return 0;
}
