
/*
 * Najdaljše skupno podzaporedje po metodi od spodaj navzgor (sistematično
 * polnjenje tabele)
 */

#include <iostream>
#include <string>
#include <vector>

using namespace std;

int main() {
    string a;
    string b;
    cin >> a >> b;

    int da = a.size();
    int db = b.size();

    // dolzina[i][j] = dolžina najdaljšega skupnega podzaporedja podnizov
    //                 a[0..i-1] in b[0..j-1]
    vector<vector<int>> dolzina(da + 1, vector<int>(db + 1));

    // smer[i][j] = kam moram iti pri rekonstrukciji najdaljšega skupnega
    //              podzaporedja (1: levo; 2: diagonalno levo navzgor; 3: navzgor)
    vector<vector<int>> smer(da + 1, vector<int>(db + 1));

    // napolnimo matriki dolžin in smeri
    for (int i = 1;  i <= da;  i++) {
        for (int j = 1;  j <= db;  j++) {

            if (a[i - 1] == b[j - 1]) {
                dolzina[i][j] = 1 + dolzina[i - 1][j - 1];
                smer[i][j] = 2;    // diagonalno levo navzgor

            } else {  // a[i - 1] != b[j - 1]
                // zgornji sosed je večji od levega
                if (dolzina[i - 1][j] > dolzina[i][j - 1]) {
                    smer[i][j] = 3;    // navzgor
                    dolzina[i][j] = dolzina[i - 1][j];

                } else {
                    smer[i][j] = 1;    // levo
                    dolzina[i][j] = dolzina[i][j - 1];
                }
            }
        }
    }

    // v spodnji desni celici se nahaja dolžina LCS za polna niza a in b
    cout << dolzina[da][db] << endl;

    // rekonstruiramo najdaljše skupno podzaporedje (v obratni smeri)

    string lcs;
    int vrstica = da;
    int stolpec = db;

    while (vrstica > 0 && stolpec > 0) {
        switch (smer[vrstica][stolpec]) {
            case 1:
                stolpec--;
                break;

            case 2:
                lcs += a[vrstica - 1];
                vrstica--;
                stolpec--;
                break;

            case 3:
                vrstica--;
                break;
        }
    }

    // odkomentirajte za izpis LCS
    /*
    for (int i = lcs.size() - 1;  i >= 0;  i--) {
        cout << lcs[i];
    }
    cout << endl;
    */

    return 0;
}
