
/*
 * Rešitev naloge Spoznavni večer
 */

#include <vector>
#include <iostream>

using namespace std;

int velikostNajMnozice(int vozlisce,
        const vector<vector<int>>& matrika, vector<int>& memo) {

    if (memo[vozlisce] > 0) {
        return memo[vozlisce];
    }

    // koliko lahko pridelamo, če vozlišča <vozlisce> ne vključimo v optimalno
    // množico (v tem primeru optimalno množico sestavimo iz optimalnih množic
    // otrok vozlišča <vozlisce>)
    int velikostOtroci = 0;

    // koliko lahko pridelamo, če vozlišče <vozlisce> vključimo v optimalno
    // množico (v tem primeru v optimalno množico dodamo tudi optimalne
    // množice vnukov vozlišča <vozlisce>)
    int velikostVnuki = 1;

    for (int otrok: matrika[vozlisce]) {
        velikostOtroci += velikostNajMnozice(otrok, matrika, memo);
        for (int vnuk: matrika[otrok]) {
            velikostVnuki += velikostNajMnozice(vnuk, matrika, memo);
        }
    }
    return memo[vozlisce] = max(velikostOtroci, velikostVnuki);
}

int main() {
    int stVozlisc, stPovezav;
    cin >> stVozlisc >> stPovezav;

    // otroci[u]: otroci vozlišča u
    vector<vector<int>> otroci(stVozlisc, vector<int>());

    // koren[u]: true, če je vozlišče u koren katerega od dreves
    vector<bool> koren(stVozlisc, true);

    for (int i = 0;  i < stPovezav;  i++) {
        int a, b;
        cin >> a >> b;
        otroci[a - 1].push_back(b - 1);
    }

    // poišči korene posameznih dreves v gozdu
    for (int u = 0;  u < stVozlisc;  u++) {
        for (int v: otroci[u]) {
            koren[v] = false;
        }
    }

    // če je memo[u] > 0, potem je memo[u] že izračunana velikost optimalne
    // množice za poddrevo, katerega koren je vozlišče <u>
    // če je memo[u] == 0, potem optimalne velikosti za poddrevo s korenom <u>
    // še nismo izračunali
    vector<int> memo(stVozlisc);

    // za vsako drevo izračunamo velikost optimalne množice in velikosti
    // seštejemo
    int velikost = 0;
    for (int u = 0;  u < stVozlisc;  u++) {
        if (koren[u]) {
            velikost += velikostNajMnozice(u, otroci, memo);
        }
    }

    cout << velikost << endl;
    return 0;
}
