#include <vector>
#include <algorithm>
#include <cstdio>

using namespace std;

const int INF = numeric_limits<int>::max();

// D[u * n + v] = dolžina povezave od u do v; ali INF, če take povezave ni
// rezultat[u * n + v] = dolžina najkrajše poti od u do v; ali INF, če take poti ni.
vector<int> FloydWarshall(int n, const vector<int>& D)
{
    vector<int> fStara, fNova;
    fStara.resize(n * n);
    fNova = D; // rešitve za k = 0
    for (int u = 0; u < n; u++) fNova[u * n + u] = 0; // za vsak primer
    // Rešimo problem še za večje k.
    for (int k = 0; k < n; k++)
    {
        // V fNova so rezultati za k - 1.
        swap(fStara, fNova);
        // V fStara so rezultati za k - 1, v fNova nastajajo rezultati za k.
        for (int u = 0; u < n; u++) for (int v = 0; v < n; v++)
        {
            int nova_uv = fStara[u * n + v];
            int stara_uk = fStara[u * n + k], stara_kv = fStara[k * n + v];
            if (stara_uk < INF && stara_kv < INF) 
                nova_uv = min(nova_uv, stara_uk + stara_kv);
            fNova[u * n + v] = nova_uv;
        }
    }
    return fNova;
}

vector<int> FloydWarshall2(int n, const vector<int>& D)
{
    vector<int> f = D; // rešitve za k = 0
    for (int u = 0; u < n; u++) f[u * n + u] = 0; // za vsak primer
    // Rešimo problem še za večje k.
    for (int k = 0; k < n; k++)
    {
        for (int u = 0; u < n; u++) for (int v = 0; v < n; v++)
        {
            int f_uk = f[u * n + k], f_kv = f[k * n + v];
            if (f_uk < INF && f_kv < INF) 
                f[u * n + v] = min(f[u * n + v], f_uk + f_kv);
        }
    }
    return f;
}

void Izpisi(int n, const vector<int>& M)
{
    for (int u = 0; u < n; u++) {
        for (int v = 0; v < n; v++) 
            if (M[u * n + v] == INF) printf("INF ");
            else printf("%3d ", M[u * n + v]);
        printf("\n"); }
}

int main()
{
    vector<int> D1 = { // cikel 0 -(10)-> 1 -(10)-> 2 -(5)-> 0 in še 3 -(8)-> 1
          0,  10, INF, INF,
        INF,   0,  10, INF,
          5, INF,   0, INF,
        INF,   8, INF,   0 };
    vector<int> R1 = FloydWarshall(4, D1);
    Izpisi(4, R1);
    printf("\n");
    //
    vector<int> D2 = { // cikel 0 -(10)-> 1 -(10)-> 2 -(-25)-> 0 in še 3 -(8)-> 1
          0,  10, INF, INF,
        INF,   0,  10, INF,
        -25, INF,   0, INF,
        INF,   8, INF,   0 };
    vector<int> R2 = FloydWarshall(4, D2);
    Izpisi(4, R2);
    //
    printf("\n\n"); R1 = FloydWarshall2(4, D1); Izpisi(4, R1);
    printf("\n"); R2 = FloydWarshall(4, D2); Izpisi(4, R2);
    return 0;
}

int Nahrbtnik(const vector<int> &mi, const vector<int> &vi, int M)
{
    vector<int> fStara, fNova;
    fStara.resize(M + 1); fNova.resize(M + 1);
    for (int c = 0; c <= M; c++) fNova[c] = 0;
    for (int k = 0; k < mi.size(); k++)
    {
        swap(fStara, fNova);
        for (int c = 0; c <= M; c++)
        {
            int kand = fStara[c];
            if (c >= mi[k]) kand = max(fStara[c - mi[k]] + vi[k]);
            fNova[c] = kand;
        }
    }
    return fNova[M];
}