#include <vector>
#include <algorithm>
#include <cstdio>

using namespace std;

void RekonstruirajReze(int n, const vector<int>& rKako, int i, int j)
{
    if (i >= j) return;
    int k = rKako[i * n + j];
    printf("Rez pri %d\n", k);
    RekonstruirajReze(n, rKako, i, k);
    RekonstruirajReze(n, rKako, k + 1, j);
}

int Resi(const vector<int>& x)
{
    int n = x.size();
    vector<int> r; r.resize(n * n);
    vector<int> rKako; rKako.resize(n * n);
    // Rešimo najprej podprobleme dolžine 1.
    for (int i = 0; i < n; i++) r[i * n + i] = 0, rKako[i * n + i] = -1; // Rešitev za x[i..i].
    // Rešimo vse daljše podprobleme.
    for (int d = 2; d <= n; d++) for (int i = 0; i + d <= n; i++)
    {
        int j = i + d - 1;
        // Rešimo podproblem za x[i..j].
        int minCena = numeric_limits<int>::max(), minKako = -1;
        int levo = 0, desno = 0; for (int k = i; k <= j; k++) desno += x[k];
        for (int k = i; k < j; k++)
        {
            levo += x[k]; desno -= x[k];
            // Zdaj je levo = vsota x[i..k], desno = vsota x[k+1..j].
            int cena = max(levo, desno) + r[i * n + k] + r[(k + 1) * n + j];
            if (cena < minCena) minCena = cena, minKako = k;
        }
        r[i * n + j] = minCena; // Zapomnimo si rešitev tega podproblema za kasneje.
        rKako[i * n + j] = minKako;
        printf("Resi(%d, %d) = %d s prvim rezom %d\n", i, j, minCena, minKako);
    }
    //
    RekonstruirajReze(n, rKako, 0, n - 1);
    return r[0 * n + (n - 1)]; // Rešitev za celo zaporedje x.
}

int main()
{
    vector<int> x = {5, 1, 2, 3};
    printf("%d\n", Resi(x));
    return 0;
}