
#include <iostream>
#include <numeric>
#include <vector>
#include <algorithm>

#include "unionFind.h"

using namespace std;

UnionFind::UnionFind(int stElementov) {
    this->stElementov = stElementov;
    this->stars = vector<int>(stElementov);
    this->stMnozic = stElementov;
    this->visina = vector<int>(stElementov);

    // vektor this->stars napolni z elementi 0, 1, ..., stElementov - 1
    iota(this->stars.begin(), this->stars.end(), 0);
}

int UnionFind::steviloMnozic() {
    return this->stMnozic;
}

void UnionFind::zdruzi(int x, int y) {
    // poi"s"ci korena dreves, ki jima pripadata elementa x in y
    int x0 = this->poisci(x);
    int y0 = this->poisci(y);

    // (domnevno) ni"zje drevo priklopi na (domnevno) vi"sje
    if (this->visina[x0] > this->visina[y0]) {
        this->stars[y0] = x0;
    } else {
        this->stars[x0] = y0;
    }

    // "ce sta drevesi enako visoki, se vi"sina ciljnega drevesa pove"ca za 1
    if (this->visina[x0] == this->visina[y0]) {
        this->visina[y0]++;
    }

    this->stMnozic--;
}

bool UnionFind::istaMnozica(int x, int y) {
    return this->poisci(x) == this->poisci(y);
}

int UnionFind::poisci(int x) {
    if (this->stars[x] == x) {
        // na"sli smo koren
        return x;
    }

    // stiskanje poti -- vsa vozli"s"ca na poti pove"zemo neposredno na koren
    return this->stars[x] = this->poisci(this->stars[x]);
}

ostream& operator<<(ostream& os, UnionFind& uf) {
    vector<bool> izpisano(uf.stElementov);
    bool prvic = true;
    for (int i = 0;  i < uf.stElementov;  i++) {
        if (izpisano[i]) {
            continue;
        }
        if (prvic) {
            prvic = false;
        } else {
            os << ", ";
        }
        os << "{" << i;
        izpisano[i] = true;
        for (int j = i + 1;  j < uf.stElementov;  j++) {
            if (uf.istaMnozica(i, j)) {
                os << ", " << j;
                izpisano[j] = true;
            }
        }
        os << "}";
    }
    return os;
}

int main() {
    UnionFind uf(12);
    cout << uf << endl;
    uf.zdruzi(3, 5);
    uf.zdruzi(2, 5);
    uf.zdruzi(1, 7);
    cout << uf << endl;
    uf.zdruzi(8, 11);
    uf.zdruzi(9, 6);
    cout << uf << endl;
    uf.zdruzi(8, 3);
    cout << uf << endl;
    uf.zdruzi(0, 6);
    uf.zdruzi(4, 7);
    cout << uf << endl;
    return 0;
}
