
#ifndef _UNIONFIND_H
#define _UNIONFIND_H

#include <vector>

using namespace std;

class UnionFind {
    private:
        // mo"c univerzalne mno"zice ("stevilo elementov vseh mno"zic skupaj)
        int stElementov;

        // stars[i]: starš elementa i (koren je sam svoj starš)
        vector<int> stars;

        // število disjunktnih množic (na začetku: stMnozic == stElementov)
        int stMnozic;

        // visina[i] = ocena višine drevesa, ki mu pripada element i
        vector<int> visina;

    public:
        // Konstruktor.
        // <stElementov>: "stevilo elementov oz. za"cetno "stevilo mno"zic
        UnionFind(int stElementov);

        // Vrne "stevilo mno"zic.
        int steviloMnozic();

        // Združi drevesi, ki mu pripadata elementa x in y.
        void zdruzi(int x, int y);

        // Vrne true natanko v primeru, če elementa x in y pripadata istemu
        // drevesu.
        bool istaMnozica(int x, int y);

        // Vrne koren drevesa, ki mu pripada element x.
        int poisci(int x);

        // Izpis na izhodni tok -- samo za potrebe preizku"sanja.
        friend ostream& operator<<(ostream& os, UnionFind& uf);
};

#endif
