
#include <iostream>
#include <vector>
#include <queue>
#include <tuple>

#include "unionFind.h"

using namespace std;
using ii = pair<int, int>;
using iii = tuple<int, int, int>;
using pq = priority_queue<iii, vector<iii>, greater<iii>>;

//
// Vrne graf v obliki prioritetne vrste trojic (c, u, v)
// (u, v sta vozli"s"ci, c je cena povezave (u, v)),
// urejene po nara"s"cajo"cih cenah.
//
pq graf2pv(int& stVozlisc) {
    int stPovezav;
    cin >> stVozlisc >> stPovezav;
    pq vrsta;
    for (int i = 0;  i < stPovezav;  i++) {
        int u, v, teza;
        cin >> u >> v >> teza;
        vrsta.push(iii(teza, u, v));
    }
    return vrsta;
}

//
// Za podani graf, predstavljen s prioritetno vrsto trojic (c, u, v), vrne
// minimalno vpeto drevo v obliki vektorja povezav.
//
vector<ii> minimalnoVpetoDrevo(int stVozlisc, pq& vrsta) {
    UnionFind gozd(stVozlisc);
    vector<ii> rezultat;

    while (gozd.steviloMnozic() > 1) {
        auto [teza, u, v] = vrsta.top();
        vrsta.pop();
        if (!gozd.istaMnozica(u, v)) {
            gozd.zdruzi(u, v);
            rezultat.push_back(ii(u, v));
        }
    }
    return rezultat;
}

int main() {
    int stVozlisc;
    pq vrsta = graf2pv(stVozlisc);
    vector<ii> drevo = minimalnoVpetoDrevo(stVozlisc, vrsta);

    for (auto [u, v]: drevo) {
        cout << u << "--" << v << endl;
    }

    return 0;
}
