
//
// Izpis mostov in prereznih to"ck v neusmerjenem grafu.
//

#include <iostream>
#include <vector>

using namespace std;

using ii = pair<int, int>;

struct DFS {
    vector<int> num;
    vector<int> low;
    vector<int> stars;  // stars[v] = star"s vozli"s"ca <v> v DFS-drevesu
    int stevec;
    int koren;
    int stOtrokKorena;

    vector<bool> prereznaTocka;
    vector<ii> mostovi;

    DFS(int stVozlisc) {
        this->num = vector<int>(stVozlisc, -1);
        this->low = vector<int>(stVozlisc, -1);
        this->stars = vector<int>(stVozlisc, -1);
        this->stevec = 0;
        this->stOtrokKorena = 0;
        this->prereznaTocka = vector<bool>(stVozlisc);
        this->mostovi = vector<ii>();
    }
};

//
// Prebere graf s standardnega vhoda.
//
vector<vector<int>> preberiGraf() {
    int stVozlisc, stPovezav;
    cin >> stVozlisc >> stPovezav;
    vector<vector<int>> graf(stVozlisc);

    for (int i = 0;  i < stPovezav;  i++) {
        int izvor, cilj;
        cin >> izvor >> cilj;
        graf[izvor].push_back(cilj);
        graf[cilj].push_back(izvor);
    }
    return graf;
}

void mostovi(const vector<vector<int>>& graf, int vozlisce, DFS& dfs) {
    dfs.low[vozlisce] = dfs.num[vozlisce] = dfs.stevec++;

    for (int sosed: graf[vozlisce]) {

        if (dfs.num[sosed] == -1) {
            // vozli"s"ce <sosed> smo pravkar odkrili
            dfs.stars[sosed] = vozlisce;

            if (vozlisce == dfs.koren) {
                // poseben primer: izhodi"s"cno vozli"s"ce DFS je prerezna
                // to"cka, "ce ima v DFS-drevesu vsaj dva otroka
                dfs.stOtrokKorena++;
            }

            mostovi(graf, sosed, dfs);
            
            // vozli"s"ce <sosed> smo obdelali

            // Je <vozlisce> prerezna to"cka?
            if (dfs.low[sosed] >= dfs.num[vozlisce]) {
                dfs.prereznaTocka[vozlisce] = true;
            }

            // Je vozlisce--sosed most?
            if (dfs.low[sosed] > dfs.num[vozlisce]) {
                dfs.mostovi.push_back(make_pair(vozlisce, sosed));
            }

            dfs.low[vozlisce] = min(dfs.low[vozlisce], dfs.low[sosed]);

        } else if (sosed != dfs.stars[vozlisce]) {

            // s povezavo vozlisce--sosed smo zaklju"cili netrivialen cikel
            dfs.low[vozlisce] = min(dfs.low[vozlisce], dfs.num[sosed]);
        }
    }
}

int main() {
    vector<vector<int>> graf = preberiGraf();
    int stVozlisc = graf.size();
    DFS dfs(stVozlisc);

    dfs.koren = 0;
    mostovi(graf, dfs.koren, dfs);
    dfs.prereznaTocka[dfs.koren] = (dfs.stOtrokKorena > 1);

    cout << "Prerezne točke:" << endl;
    for (int i = 0;  i < stVozlisc;  i++) {
        if (dfs.prereznaTocka[i]) {
            cout << i << endl;
        }
    }

    cout << endl;
    cout << "Mostovi:" << endl;
    for (ii povezava: dfs.mostovi) {
        cout << povezava.first << "--" << povezava.second << endl;
    }

    return 0;
}
