
//
// Topolo"sko urejanje usmerjenega acikli"cnega grafa --- Kahnov algoritem
//

#include <iostream>
#include <vector>
#include <algorithm>
#include <queue>

using namespace std;

int main() {
    int stVozlisc, stPovezav;
    cin >> stVozlisc >> stPovezav;
    vector<vector<int>> graf(stVozlisc);

    // stVstopnih[v]: "stevilo povezav, ki vstopajo v vozli"s"ce <v>
    vector<int> stVstopnih(stVozlisc);

    for (int i = 0; i < stPovezav; i++) {
        int u, v;
        cin >> u >> v;
        graf[u].push_back(v);
        stVstopnih[v]++;
    }

    // prioritetna vrsta, ki hrani vsa vozli"s"ca brez vstopnih povezav
    priority_queue<int, vector<int>, greater<int>> vrsta;
    for (int v = 0; v < stVozlisc; v++) {
        if (stVstopnih[v] == 0) {
            vrsta.push(v);
        }
    }

    while (!vrsta.empty()) {
        int vozlisce = vrsta.top();
        cout << vozlisce << endl;
        vrsta.pop();

        // odstranimo <vozlisce> iz grafa (vsakemu sosedu vozli"s"ca
        // <vozlisce> odstranimo po eno vstopno povezavo)
        for (int sosed: graf[vozlisce]) {
            if (--stVstopnih[sosed] == 0) {
                vrsta.push(sosed);
            }
        }
    }

    return 0;
}
