
//
// Topolo"sko urejanje usmerjenega acikli"cnega grafa --- Tarjanov algoritem
//

#include <iostream>
#include <vector>
#include <algorithm>

using namespace std;

//
// Prebere graf s standardnega vhoda.
//
vector<vector<int>> preberiGraf() {
    int stVozlisc, stPovezav;
    cin >> stVozlisc >> stPovezav;
    vector<vector<int>> graf(stVozlisc);

    for (int i = 0; i < stPovezav; i++) {
        int u, v;
        cin >> u >> v;
        graf[u].push_back(v);
    }

    return graf;
}

void dfs(const vector<vector<int>>& graf, int vozlisce, vector<bool>& obiskano, vector<int>& vrstniRed) {
    obiskano[vozlisce] = true;

    for (int sosed: graf[vozlisce]) {
        if (!obiskano[sosed]) {
            dfs(graf, sosed, obiskano, vrstniRed);
        }
    }

    // <vozlisce> je obdelano
    vrstniRed.push_back(vozlisce);
}

int main() {
    vector<vector<int>> graf = preberiGraf();
    int stVozlisc = graf.size();
    vector<bool> obiskano(stVozlisc);
    vector<int> vrstniRed;

    for (int v = 0; v < stVozlisc; v++) {
        if (!obiskano[v]) {
            dfs(graf, v, obiskano, vrstniRed);
        }
    }

    // topolo"ski vrstni red = vrstni red, nasproten vrstnemu redu obdelanosti vozli"s"c
    reverse(vrstniRed.begin(), vrstniRed.end());
    for (int v: vrstniRed) {
        cout << v << endl;
    }

    return 0;
}
