
//
// Osnovni algoritem iskanja v globino (DFS).
//

#include <iostream>
#include <vector>

using namespace std;

//
// Prebere graf s standardnega vhoda.
//
vector<vector<int>> preberiGraf() {
    int stVozlisc, stPovezav;
    cin >> stVozlisc >> stPovezav;
    vector<vector<int>> graf(stVozlisc);

    for (int i = 0; i < stPovezav; i++) {
        int u, v;
        cin >> u >> v;
        graf[u].push_back(v);
    }

    return graf;
}

void dfs(const vector<vector<int>>& graf, int vozlisce, vector<bool>& obiskano) {
    cout << vozlisce << endl;
    obiskano[vozlisce] = true;

    for (int sosed: graf[vozlisce]) {
        if (!obiskano[sosed]) {
            dfs(graf, sosed, obiskano);
        }
    }
}

int main() {
    vector<vector<int>> graf = preberiGraf();
    vector<bool> obiskano(graf.size());

    dfs(graf, 0, obiskano);
    return 0;
}
