
#include <iostream>
#include <vector>

using namespace std;

// stanja vozli"s"ca
const int NEODKRITO = 0;
const int OBISKANO = 1;
const int OBDELANO = 2;

//
// Prebere graf s standardnega vhoda.
//
vector<vector<int>> preberiGraf() {
    int stVozlisc, stPovezav;
    cin >> stVozlisc >> stPovezav;
    vector<vector<int>> graf(stVozlisc);

    for (int i = 0; i < stPovezav; i++) {
        int u, v;
        cin >> u >> v;
        graf[u].push_back(v);
    }

    return graf;
}

void dfs(const vector<vector<int>>& graf, int vozlisce, vector<int>& stanje, vector<int>& stars) {
    stanje[vozlisce] = OBISKANO;

    for (int sosed: graf[vozlisce]) {

        if (stanje[sosed] == OBISKANO) {
            cout << "povratna povezava: " << vozlisce << " -> " << sosed << endl;
            if (stars[vozlisce] == sosed) {
                cout << "dvosmerna povezava: " << vozlisce << " -> " << sosed << endl;
            } else {
                cout << "cikel" << endl;
            }

        } else if (stanje[sosed] == OBDELANO) {
            cout << "prečna povezava: " << vozlisce << " -> " << sosed << endl;

        } else {
            stars[sosed] = vozlisce;
            cout << "drevesna povezava: " << vozlisce << " -> " << sosed << endl;
            dfs(graf, sosed, stanje, stars);
        }
    }

    stanje[vozlisce] = OBDELANO;
}

int main() {
    vector<vector<int>> graf = preberiGraf();
    int stVozlisc = graf.size();

    vector<int> stanje(stVozlisc, 0);
    vector<int> stars(stVozlisc, -1);

    dfs(graf, 0, stanje, stars);
    return 0;
}
