
/*
 * Krepko povezane komponente v usmerjenem grafu --- Kosarajujev algoritem
 */

#include <iostream>
#include <vector>
#include <algorithm>
#include <iterator>

using namespace std;

//
// Prebere graf s standardnega vhoda.  V izhodni parameter obrGraf vpi"se graf
// z obrnjenimi povezavami.
//
vector<vector<int>> preberiGraf(vector<vector<int>>& obrGraf) {
    int stVozlisc, stPovezav;
    cin >> stVozlisc >> stPovezav;
    vector<vector<int>> graf(stVozlisc);
    obrGraf.assign(stVozlisc, vector<int>());

    for (int i = 0;  i < stPovezav;  i++) {
        int izvor, cilj;
        cin >> izvor >> cilj;
        graf[izvor].push_back(cilj);
        obrGraf[cilj].push_back(izvor);
    }
    return graf;
}

//
// vrstniRed: vozlišča, urejena po obdelanosti (na začetku bo vozlišče, ki bo
// prvo obdelano)
//
void dfs(const vector<vector<int>>& graf, int v, vector<bool>& obiskano, vector<int>& vrstniRed) {
    obiskano[v] = true;
    for (int sosed: graf[v]) {
        if (!obiskano[sosed]) {
            dfs(graf, sosed, obiskano, vrstniRed);
        }
    }
    vrstniRed.push_back(v);
}

int main() {
    vector<vector<int>> obrGraf;
    vector<vector<int>> graf = preberiGraf(obrGraf);
    int stVozlisc = graf.size();

    // po"zenemo DFS, da dolo"cimo vrstni red obdelanosti vozli"s"c
    vector<bool> obiskano(stVozlisc);
    vector<int> vrstniRed;
    for (int v = 0; v < stVozlisc; v++) {
        if (!obiskano[v]) {
            dfs(graf, v, obiskano, vrstniRed);
        }
    }

    obiskano.assign(obiskano.size(), false);
    int stevec = 0;

    // vozli"s"ca obravnavamo po padajo"cem vrstnem redu obdelanosti;
    // vsakokrat po"zenemo DFS

    for (int i = stVozlisc - 1; i >= 0; i--) {
        int vozlisce = vrstniRed[i];
        if (!obiskano[vozlisce]) {
            vector<int> komponenta;
            dfs(obrGraf, vozlisce, obiskano, komponenta);
            stevec++;
            cout << "komponenta " << stevec << endl;
            for (int v: komponenta) {
                cout << v << endl;
            }
        }
    }

    return 0;
}
