
/*
 * Krepko povezane komponente v usmerjenem grafu --- Tarjanov algoritem
 */

#include <iostream>
#include <vector>
#include <stack>

using namespace std;

//
// podatki, ki jih hranimo med izvajanjem DFS
//
struct DFS {
    vector<int> num;
    vector<int> low;
    stack<int> sklad;
    vector<bool> delKomponente;  // true, "ce je vozli"s"ce del trenutne komponente
    int stevec;
    int stKomponent;

    DFS(int stVozlisc) {
        this->num = vector<int>(stVozlisc, -1);
        this->low = vector<int>(stVozlisc, -1);
        this->delKomponente = vector<bool>(stVozlisc, -1);
        this->stevec = 0;
        this->stKomponent = 0;
    }
};

//
// Prebere graf s standardnega vhoda.
//
vector<vector<int>> preberiGraf() {
    int stVozlisc, stPovezav;
    cin >> stVozlisc >> stPovezav;
    vector<vector<int>> graf(stVozlisc);

    for (int i = 0;  i < stPovezav;  i++) {
        int izvor, cilj;
        cin >> izvor >> cilj;
        graf[izvor].push_back(cilj);
    }
    return graf;
}

void povezaneKomponente(const vector<vector<int>>& graf, int vozlisce, DFS& dfs) {
    dfs.low[vozlisce] = dfs.num[vozlisce] = dfs.stevec++;
    dfs.sklad.push(vozlisce);
    dfs.delKomponente[vozlisce] = true;

    for (int sosed: graf[vozlisce]) {
        if (dfs.num[sosed] == -1) {
            // <vozlisce> smo pravkar odkrili
            povezaneKomponente(graf, sosed, dfs);
        }

        if (dfs.delKomponente[sosed]) {
            // <sosed> pripada isti komponenti kot <vozlisce>
            dfs.low[vozlisce] = min(dfs.low[vozlisce], dfs.low[sosed]);
        }
    }

    // <vozlisce> smo obdelali

    if (dfs.num[vozlisce] == dfs.low[vozlisce]) {
        dfs.stKomponent++;
        cout << "komponenta " << dfs.stKomponent << endl;

        // pobiramo vozli"s"ca s sklada, dokler ne naletimo na <vozlisce>;
        // vsa pobrana vozli"s"ca tvorijo krepko povezano komponento
        int v = 0;
        do {
            v = dfs.sklad.top();
            cout << v << endl;
            dfs.sklad.pop();
            dfs.delKomponente[v] = false;
        } while (v != vozlisce);
    }
}

int main() {
    vector<vector<int>> graf = preberiGraf();
    int stVozlisc = graf.size();
    DFS dfs(stVozlisc);

    for (int v = 0; v < stVozlisc; v++) {
        if (dfs.num[v] < 0) {
            povezaneKomponente(graf, v, dfs);
        }
    }
    return 0;
}
