/*
 * Najdaljše skupno podzaporedje (LCS)
 */

#include <cstdio>
#include <cstring>
#include <algorithm>
using namespace std;

const int MAX_LEN = 200;
char a[MAX_LEN], b[MAX_LEN];

int lcs(char *a, char *b) {
  int dp[MAX_LEN][MAX_LEN];
  int la = strlen(a);
  int lb = strlen(b);
  
  for (int i=0; i<=la; i++) dp[lb][i] = 0;
  for (int i=0; i<=lb; i++) dp[i][la] = 0;
  
  for (int i=lb-1; i>=0; i--) {
    for (int j=la-1; j>=0; j--) {
      if (a[j] == b[i]) dp[i][j] = 1 + dp[i+1][j+1];
      else dp[i][j] = max(dp[i][j+1], dp[i+1][j]);
    }
  }
  
  return dp[0][0];
}

int main() {
  scanf("%s", a);
  scanf("%s", b);
  printf("%d\n", lcs(a, b));
  return 0;
}
