#include <stdio.h>

// na indeksu i reseto shranjuje
// nek praštevilski delitelj števila i,
// če pa je i praštevilo, je tam shranjeno 0
int reseto[1002];
int N = 1000;

// rešetiraj
void resetiraj() {
    for (int i = 2; i*i <= N; i++) {
        // če je i praštevilo
        if (reseto[i] == 0) {
            // Najdeno praštevilo
            // prečrtamo vse njegove večkratnike
            for (int j = 2*i; j <= N; j += i) {
                // i je praštevilo, ki deli j
                reseto[j] = i;
            }
        }
    }
}

int main() {

    resetiraj();

    printf("Prastevila do %d:\n", N);

    for (int i = 2; i < N; i++) {
        if (reseto[i] == 0) {
            printf("Prastevilo: %d\n", i);
        } else {
            printf("%d NI prastevilo, ker je deljivo z %d\n", i, reseto[i]);
        }
    }
    return 0;
}
