#include <stdio.h>

// int - 10^9
// naloga želi števila do 10^18
// zato uporabimo long long

// long = int
// long long gre do 10^18

// ll od sedaj naprej pomeni long long
typedef long long ll;

// gcd - greatest common divisor
// (angl. največji skupni delitelj)
ll gcd(ll a, ll b) {
    ll c = a % b;
    while (c != 0) {
        //printf("debug: %d %d\n", a, b);
        a = b;
        b = c;
        c = a % b;
    }
    return b;
}

// izračuna najmanjši skupni večkratnik števil a, b
ll lcm(ll a, ll b) {
    return (a / gcd(a, b)) * b;
}

int main() {
    // preberi dve števili in
    // izračunaj LCM
    ll a, b;
    scanf("%lld%lld", &a, &b);
    printf("%lld\n", lcm(a, b));
    return 0;
}
