
/*
 * Najdaljše skupno podzaporedje po metodi od zgoraj navzdol (rekurzija +
 * memoizacija)
 */

#include <iostream>
#include <string>
#include <vector>

using namespace std;

// Vrne dolžino LCS za podniza a[0..i-1] in b[0..j-1].
// dolzina[i][j]: memoizirana dolžina LCS(a[0..i-1], b[0..j-1])
// ze[i][j]: true, če smo vrednost dolzina[i][j] že izračunali
// smer[i][j]: memoizirana smer rekonstrukcije

int izracunaj(int i, int j, const string& a, const string& b,
        vector<vector<int>>& dolzina, vector<vector<bool>>& ze,
        vector<vector<int>>& smer) {

    if (i == 0 || j == 0) {
        return 0;
    }
    if (ze[i][j]) {
        return dolzina[i][j];
    }
    ze[i][j] = true;

    if (a[i - 1] == b[j - 1]) {
        smer[i][j] = 2;
        return dolzina[i][j] = izracunaj(i - 1, j - 1, a, b, dolzina, ze, smer) + 1;
    }

    int levo = izracunaj(i, j - 1, a, b, dolzina, ze, smer);
    int zgoraj = izracunaj(i - 1, j, a, b, dolzina, ze, smer);

    if (levo > zgoraj) {
        smer[i][j] = 1;
        return dolzina[i][j] = levo;
    }

    smer[i][j] = 3;
    return dolzina[i][j] = zgoraj;
}

int main() {
    string a;
    string b;
    cin >> a >> b;

    int da = a.size();
    int db = b.size();

    // dolžine najdaljših skupnih podzaporedij
    vector<vector<int>> dolzina(da + 1, vector<int>(db + 1));
    
    // ze[i][j] == true <==> dolzina[i][j] smo že izračunali
    vector<vector<bool>> ze(da + 1, vector<bool>(db + 1));

    // smeri (1: levo; 2: diagonalno levo navzgor; 3: navzgor)
    vector<vector<int>> smer(da + 1, vector<int>(db + 1));

    cout << izracunaj(da, db, a, b, dolzina, ze, smer) << endl;

    // rekonstruiramo najdaljše skupno podzaporedje (v obratni smeri)

    string lcs;
    int vrstica = da;
    int stolpec = db;
    int k = 0;
    while (vrstica > 0 && stolpec > 0) {
        switch (smer[vrstica][stolpec]) {
            case 1:
                stolpec--;
                break;

            case 2:
                lcs += a[vrstica - 1];
                vrstica--;
                stolpec--;
                break;

            case 3:
                vrstica--;
                break;
        }
    }

    // odkomentirajte za izpis LCS
    /*
    for (int i = lcs.size() - 1;  i >= 0;  i--) {
        cout << lcs[i];
    }
    cout << endl;
    */

    return 0;
}
