
/*
 * Najdaljše naraščajoče podzaporedje v času O(n^2)
 */

#include <iostream>
#include <vector>

using namespace std;

// Vrne dolžino najdaljšega naraščajočega podzaporedja v zaporedju vhod[i..n-1].
// Če je memo[i] > 0, potem smo dolžino vhod[i..n-1] že izračunali (hrani jo memo[i]).

int lis(const vector<int>& vhod, int i, int n, vector<int>& memo) {
    if (i == n) {
        return 0;
    }
    if (memo[i] > 0) {
        return memo[i];
    }

    // v podzaporedje dodaj trenutni element
    int rezultat = 1;

    // izberi optimalno nadaljevanje (med vsemi elementi vhod[i+1..n-1],
    // ki so večji od vhod[i])
    for (int j = i;  j < n;  j++) {
        if (vhod[j] > vhod[i]) {
            rezultat = max(rezultat, lis(vhod, j, n, memo) + 1);
        }
    }
    return memo[i] = rezultat;
}

int main() {
    int n;
    cin >> n;
    vector<int> vhod(n);
    for (int i = 0;  i < n;  i++) {
        cin >> vhod[i];
    }

    vector<int> memo(n);

    // Za vsak i izračunaj dolžino najdaljšega podzaporedja v zaporedju
    // vhod[i..n-1] in izberi maksimalno (med vsemi i \in {0, ..., n - 1}).
    int dolzina = 0;
    for (int i = 0;  i < n;  i++) {
        dolzina = max(dolzina, lis(vhod, i, n, memo));
    }
    cout << dolzina << endl;

    return 0;
}
