
#include <iostream>
#include <vector>
#include <queue>
#include <tuple>

using namespace std;
using ii = pair<int, int>;
using iii = tuple<int, int, int>;
using pq = priority_queue<iii, vector<iii>, greater<iii>>;

//
// Prebere graf v obliki vektorja
// [S_1, S_2, ..., S_n], kjer je 
// S_i = [(v_{i, 1}, w_{i, 1}), (v_{i, 2}, w_{i, 2}), ..., (v_{i, k_i}, w_{i, k_i})];
// v_{i, j} je j-ti sosed vozli"s"ca i;
// w_{i, j} je cena povezave i -- v_{i, j}.
//
vector<vector<ii>> preberiGraf() {
    int stVozlisc, stPovezav;
    cin >> stVozlisc >> stPovezav;
    vector<vector<ii>> graf(stVozlisc);

    for (int i = 0; i < stPovezav; i++) {
        int izvor, cilj, cena;
        cin >> izvor >> cilj >> cena;
        graf[izvor].push_back(ii(cilj, cena));
        graf[cilj].push_back(ii(izvor, cena));
    }
    return graf;
}

//
// Za podani graf vrne minimalno vpeto drevo v obliki vektorja povezav (u, v).
//
vector<ii> minimalnoVpetoDrevo(const vector<vector<ii>>& graf) {
    int stVozlisc = graf.size();

    // vDrevesu[i] == true: vozli"s"ce i je "ze del drevesa
    vector<bool> vDrevesu(stVozlisc);

    // prioritetna vrsta trojic (cena, u, v), organizirana po nara"s"cajo"cih
    // cenah povezav (u, v)
    pq vrsta;

    // minimalno vpeto drevo
    vector<ii> rezultat;

    // vozli"s"ce 0 dodamo v drevo, vse njegove povezave pa v prioritetno
    // vrsto
    vDrevesu[0] = true;
    for (auto [sosed, cena]: graf[0]) {
        vrsta.push(iii(cena, 0, sosed));
    }

    int stDodanihPovezav = 0;
    while (stDodanihPovezav < stVozlisc - 1) {
        // poberemo prvo (najcenej"so) povezavo iz prioritetne vrste
        auto [cena, izvor, cilj] = vrsta.top();
        vrsta.pop();

        // "ce ciljno vozli"s"ce "se ni v drevesu, ga dodamo v drevo, v
        // prioritetno vrsto pa dodamo vse njegove povezave do vozli"s"c, ki
        // "se niso v drevesu
        if (!vDrevesu[cilj]) {
            vDrevesu[cilj] = true;
            for (auto [sosed, cena]: graf[cilj]) {
                if (!vDrevesu[sosed]) {
                    vrsta.push(iii(cena, cilj, sosed));
                }
            }
            rezultat.push_back(ii(izvor, cilj));
            stDodanihPovezav++;
        }
    }
    return rezultat;
}

int main() {
    vector<vector<ii>> graf = preberiGraf();
    vector<ii> drevo = minimalnoVpetoDrevo(graf);
    for (auto [izvor, cilj]: drevo) {
        cout << izvor << "--" << cilj << endl;
    }

    return 0;
}
