#include <stdio.h>
#include <set>
#include <unordered_set>
using namespace std;

int main() {
	
	set<int> mnozica;
	
	/*
	// Za dodajanje uporabimo metodo insert()
	// ta deluje v O(log n)
	mnozica.insert(1);
	mnozica.insert(7);
	mnozica.insert(4);
	mnozica.insert(3);
	
	for (int x : mnozica) {
		printf("%d\n", x);
	}
	*/
	
	/*
	// Nov algoritem za urejanje!
	// O(n log n)
	int n;
	scanf("%d", &n);
	for (int i = 0; i < n; i++) {
		int t;
		scanf("%d", &t);
		mnozica.insert(t);
	}
	
	for (int x : mnozica) {
		printf("%d ", x);
	}
	printf("\n");
	*/
	
	unordered_set<int> neurejena_mnozica;
	
	for (int i = 0; i < 100; i++) {
		neurejena_mnozica.insert(i * 7 + (1 << 25));  // O(1)
	}
	
	for (int x : neurejena_mnozica) {
		printf("%d\n", x);
	}
	
	// za odstranjevanje uporabimo erase()
	neurejena_mnozica.erase(1 << 25);
	
	// če nas zanima, ali je element(število) v množici, uporabimo
	if (neurejena_mnozica.count((1 << 25) + 7)) {
		printf("ja\n");
	}
	
	// množice in multimnožice lahko hranijo le eno ponovitev vsakega
	// števila (elementa), ne moremo imeti več ponovitev istih elementov.
	// npr. če dodamo 3, 5, 6, 7, 3, 5 v množico, bo imela velikost 4
	
	neurejena_mnozica.clear();  // izbriše vse elemente
	neurejena_mnozica.insert(3);
	neurejena_mnozica.insert(5);
	neurejena_mnozica.insert(6);
	neurejena_mnozica.insert(7);
	neurejena_mnozica.insert(3);
	neurejena_mnozica.insert(5);
	
	printf("%d\n", neurejena_mnozica.size());
	
	return 0;
}
