#include <stdio.h>
#include <map>
using namespace std;

// map : urejen slovar  -- vse operacije O(log n)
// unordered_map : neurejen slovar  -- operacije O(1)

int main() {
	
	map<char, int> slovar;
	// slovar je pravzaprav set<pair<..., ...>>
	
	slovar['a'] = 7;  // O(log n)
	slovar['g'] = 9;
	slovar['A'] = -1;
	slovar['g'] = 11;
	slovar['b'] = 7;
	
	slovar.insert({ 'L', 9 });
	
	// odstranjujemo lahko po ključih ali po iteratorjih
	// slovar.erase('g');  // O(log n)
	// slovar.erase(slovar.find('b'));
	
	// recimo, da si zelimo odstraniti vse vnose, ki imajo kljuc z
	// malo crko angleske abecede
	// lahko uporabimo metodo lower_bound:
	while (true) {
		auto it = slovar.lower_bound('a');  // O(log n)
		if (it == slovar.end()) {
			// ni več vnosov, ki bi imeli malo črko, 
			// ker nismo našli nobenega vnosa s ključem, večjim ali
			// enakim 'a'
			break;
		}
		printf("odstranjujem %c\n", (*it).first);
		slovar.erase(it);
	}
	
	printf("Ali je A v slovarju? %d\n", slovar.count('A'));
	
	printf("%d\n", slovar.size());
	
	for (pair<char, int> par: slovar) {
		printf("crki %c smo pripisali vrednost %d\n", par.first, par.second);
	}
	
	return 0;
}
