#include <stdio.h>

int n, k;
int izbor[20];

void f(int stevilo, int preostala) {
	// Glavna ideja je naslednja:
	// Funkcija sprejme dva arugmenta. Prvi pove, na katerem
	// elementu seznama (1, 2, ..., n) se nahajamo, drugi
	// argument pa pove, koliko ŠE števil moramo izbrati
	
	// Če je stevilo == n+1 in preostala == 0,
	// povem vemo, da smo prišli do konca seznama in pri tem
	// izbrali natanko k elementov. To izbiro sedaj izpišemo!
	
	// Če je stevilo == n+1 in preostala != 0,
	// potem nismo uspešno izbrali k elementov, torej ne naredimo nič.
	
	// Če pa je število < n+1, potem poiskusimo dve možnosti:
	// Ali izberemo trenutno število, ali pa ga ne izberemo
	
	if (stevilo == n+1 && preostala == 0) {
		
		// naredili smo izbor
		for (int i = 0; i < k; i++) {
			printf("%d ", izbor[i]);
		}
		printf("\n");
		
	} else if (stevilo == n+1 && preostala != 0) {
		// neveljaven izbor, saj nismo našli k stvari
	} else {
		// zabeležimo si, da smo izbrali stevilo
		izbor[k-preostala] = stevilo;
		f(stevilo+1, preostala-1);
		
		// zabeležimo si, da nismo izbrali števila
		izbor[k-preostala] = 0;
		f(stevilo+1, preostala);
	}
}

void g(int stevilo, int idx) {
	if (stevilo == n+1) {
		for (int i = 0; i < idx; i++) {
			printf("%d ", izbor[i]);
		}
		printf("\n");
	} else {
		izbor[idx] = stevilo;
		g(stevilo+1, idx+1);
		
		izbor[idx] = 0;
		g(stevilo+1, idx);
	}
}

int main() {
	// scanf("%d%d", &n, &k);
	scanf("%d", &n);
	
	// Poiskati želimo vse možne izbore k stvari izmed
	// števil 1, 2, ..., n
	// To naredimo z rekurzijo:
	
	// f(1, k);
	
	// Kaj pa za vse nabore teh števil?
	
	/*
	for (k = 0; k <= n; k++) {
		f(1, k);
	}
	*/
	
	g(1, 0);
	
	return 0;
}
