#include <stdio.h>

int izbor[30];
int stranke[30];
int n;

int najboljsi_izbor[30];
int najboljsa_razlika = 1000000;

void preglej_moznosti(int stranka, int st_izbranih) {
	if (stranka == n) {
		// obravnavamo trenutni izbor: pregledati moramo, ali je
		// vsota trenutnega izbora večja kot polovična vsota vsega,
		// in ali je ta izbor do sedaj najboljši
		
		// Izračunamo vsoto trenutnega izbora
		int vsota = 0;
		for (int i = 0; i < st_izbranih; i++) {
			vsota += stranke[izbor[i]];
		}
		
		int vsota_vseh = 0;
		for (int i = 0; i < n; i++) {
			vsota_vseh += stranke[i];
		}
		int vsota_neizbranih = vsota_vseh - vsota;
		
		// Pregledamo, če je izbor dopusten
		if (vsota <= vsota_neizbranih) {
			return;
		}
		
		// Pregledamo, če je to najboljši izbor do sedaj
		int razlika = vsota - vsota_neizbranih;
		if (razlika < najboljsa_razlika) {
			najboljsa_razlika = razlika;
			for (int i = 0; i < st_izbranih; i++) {
				najboljsi_izbor[i] = izbor[i];
			}
			najboljsi_izbor[st_izbranih] = -1;
		}
		
	} else {
		izbor[st_izbranih] = stranka;
		preglej_moznosti(stranka+1, st_izbranih+1);
		
		izbor[st_izbranih] = 0;
		preglej_moznosti(stranka+1, st_izbranih);
	}
}

int main() {
	scanf("%d", &n);
	for (int i = 0; i < n; i++) {
		scanf("%d", &stranke[i]);
	}
	
	preglej_moznosti(0, 0);
	
	for (int i = 0; najboljsi_izbor[i] != -1; i++) {
		printf("%d ", najboljsi_izbor[i]+1);
	}
	printf("\n");
	
	return 0;
}
