#include <stdio.h>

char niz[1000];

int main() {
	
	// Kako računalniku podamo številko, zapisano v binarni obliki?
	
	/*
	int a = 0b1100;
	printf("%d\n", a);
	*/
	
	// Kako pa izpišemo nekaj v bitni obliki?
	
	unsigned int b = 0b11001;
	unsigned int c = 0b10;
	
	unsigned int a = b >> 3;
	
	// operator | števili združi tako, da je posamičen bit
	// prižgan, če je bil prižgan pri vsaj enem od vhodnih števil
	// 101 | 10001 = 10101
	
	// operator & števili združi tako, da je posamičen bit
	// prižgan, če je bil prižgan pei OBEH vhodih
	// 101 & 10001 = 1
	// 11100 & 00111 = 100
	
	// operator ^ števili združi tako, da je posamičen bit
	// prižgan, če je bil prižgan pri natanko enem od vhodov
	// 11100 ^ 00111 = 11011
	// 10 ^ 10 = 0
	
	// operator ~ obrne vse bite v enem številu
	// ~11001 = 11111111111111111111111111100110
	
	// obstajajo tudi druge bitne operacije, npr. NAND (not and)
	// ti operatorji nimajo posebnega znaka, ker jih enostavno
	// zapišemo z že znanimi znaki: a NAND b = ~(a & b)
	
	// operator << doda ničle na konec številke:
	// 11001 << 3 = 11001000
	
	// operator >> izbriše mesta z desne:
	// 11001 >> 3 = 11
	
	// -------------------
	
	int i = 0;
	while (a != 0) {
		niz[i] = '0' + (a % 2);
		i++;
		a /= 2;
	}
	
	// Obrnemo niz v drug vrstni red
	for (int j = i-1; j >= 0; j--) {
		printf("%c", niz[j]);
	}
	printf("\n");
	
	return 0;
}
