#include <stdio.h>

char niz[1000];

int main() {
	unsigned int a = 0b1101011;
	
	// Želimo nastaviti 4-ti bit v a-ju na 1.
	// Torej, v tem primeru bo nov a = 1101011
	
	a = a | (1 << 3);
	
	// 1 << 3 = 1000
	// a | 1000 = nastavi 4. bit na 1, ne glede na to, kaj je tam v a
	
	
	// Podobno, če želim nastaviti 4-ti bit na 0, naredim:
	a = a & ~(1 << 3);
	
	// 1 << 3 = 1000
	// ~(1 << 3) = 111111...110111
	// a & 111111...110111 = nastavi 4. bit na 0, ostalo pusti na miru
	
	// Podobno, če želim obrniti 4-ti bit:
	a = a ^ (1 << 3);
	
	// Kaj pa, če želim dostopati do 4-tega bita?
	if (a & (1 << 3)) {
		printf("DA\n");
	} else {
		printf("NE\n");
	}
	
	// 1101011 & (1 << 3) = 1101011 & 0001000 = 0001000
	
	
	
	// Kako pa se <<, >> obnašata matematično?
	// Razmislek je podoben kot pri decimalnih številih, ko množimo
	// oziroma delimo z 10.
	// Enostavno vidimo, da je
	// a << 1 = 2 * a
	// a >> 1 = a / 2
	
	// Kot posledica: 2^n (potenca) = 1 << n
	// torej lahko enostavno izračunamo potence števila 2!
	// Namesto for zanke lahko potence 2 izračunamo tako
	
	
	
	//------------------
	int i = 0;
	while (a > 0) {
		niz[i] = '0' + (a % 2);
		i++;
		a /= 2;
	}
	
	// Obrnemo niz v drug vrstni red
	for (int j = i-1; j >= 0; j--) {
		printf("%c", niz[j]);
	}
	printf("\n");
	
	return 0;
}
