// Pokliči funkcijo poteza('X'), da računalnik odigra X, oziroma poteza('O'),
// da odigra O. Funkcija bo direktno zapisala potezo na pravilno mesto v
// tabelo polje[3][3] spodaj.

// V vsakem polju morajo biti bodisi presledek ' ', črka 'O' ali črka 'X'
char polje[3][3];

// +1 za vsako polcrto, ki jo imam
// -1 za vsako polcrto, ki jo ima on
// +1000 če sem zmagal
// -1000 če je on zmagal
int oceni(char kdo) {
    int ocena = 0;

    for (int i = 0; i < 3; i++) {
        int st_1 = 0, st_2 = 0;
        for (int j = 0; j < 3; j++) {
            if (polje[i][j] == ' ') continue;
            if (polje[i][j] == kdo) st_1++;
            else st_2++;
        }
        if (st_1 == 2 && st_2 == 0) ocena += 1;
        if (st_1 == 0 && st_2 == 2) ocena -= 1;
        if (st_1 == 3) ocena += 1000;
        if (st_2 == 3) ocena -= 1000;
    }

    for (int j = 0; j < 3; j++) {
        int st_1 = 0, st_2 = 0;
        for (int i = 0; i < 3; i++) {
            if (polje[i][j] == ' ') continue;
            if (polje[i][j] == kdo) st_1++;
            else st_2++;
        }
        if (st_1 == 2 && st_2 == 0) ocena += 1;
        if (st_1 == 0 && st_2 == 2) ocena -= 1;
        if (st_1 == 3) ocena += 1000;
        if (st_2 == 3) ocena -= 1000;
    }

    int st_1 = 0, st_2 = 0;
    for (int i = 0; i < 3; i++) {
        if (polje[i][i] == ' ') continue;
        if (polje[i][i] == kdo) st_1++;
        else st_2++;
    }
    if (st_1 == 2 && st_2 == 0) ocena += 1;
    if (st_1 == 0 && st_2 == 2) ocena -= 1;
    if (st_1 == 3) ocena += 1000;
    if (st_2 == 3) ocena -= 1000;

    st_1 = 0, st_2 = 0;
    for (int i = 0; i < 3; i++) {
        if (polje[i][2-i] == ' ') continue;
        if (polje[i][2-i] == kdo) st_1++;
        else st_2++;
    }
    if (st_1 == 2 && st_2 == 0) ocena += 1;
    if (st_1 == 0 && st_2 == 2) ocena -= 1;
    if (st_1 == 3) ocena += 1000;
    if (st_2 == 3) ocena -= 1000;

    return ocena;
}

char drug(char kdo) {
    if (kdo == 'O') return 'X';
    return 'O';
}

// Vrne: najljubša poteza (i,j), ocena dobrote najboljše poteze
int* minimax(char kdo, int rem_depth) {
    int* polozaj = (int*)malloc(3*sizeof(int));
    if (rem_depth == 0) {
        polozaj[0] = polozaj[1] = -1;
        polozaj[2] = oceni(kdo);
        return polozaj;
    }

    int bi = -1, bj = -1;
    int bestval = -1000000;

    for (int i = 0; i < 3; i++) {
        for (int j = 0; j < 3; j++) {
            if (polje[i][j] != ' ') continue;
            polje[i][j] = kdo;
            if (oceni(kdo) > 500) {
                polje[i][j] = ' ';
                polozaj[0] = i;
                polozaj[1] = j;
                polozaj[2] = 1000;
                return polozaj;
            }
            int* pp = minimax(drug(kdo), rem_depth-1);
            polje[i][j] = ' ';
            if (-pp[2] > bestval) {
                bestval = -pp[2];
                bi = i, bj = j;
            }
            free(pp);
        }
    }

    polozaj[0] = bi;
    polozaj[1] = bj;
    polozaj[2] = bestval;
    return polozaj;
}

void poteza(char kdo) {
    int* polozaj = minimax(kdo, 3);
    polje[polozaj[0]][polozaj[1]] = kdo;
    free(polozaj);
}
