// V spremenljivki V mora biti shranjena višina mreže, v spremenljivki
// S pa širina mreže. Če je luč prižgana, naj bo na primernem mestu na
// mreži enica, sicer pa ničla.
// Spremenljivka kopija je pomožna, ne je uporabljati ali brisati.
// Kliči funkcijo preveri(), da preveriš, če obstaja rešitev.
int V, S;
int mreza[200][200], kopija[200][200];

#include <utility>
using std::swap;
 
void kopiraj() {
	for (int i = 0; i < V; i++) {
		for (int j = 0; j < S; j++) {
			kopija[i][j] = mreza[i][j];
		}
	}
}
 
void flip(int i, int j) {
	kopija[i][j] ^= 1;
	if (i > 0) kopija[i-1][j] ^= 1;
	if (j > 0) kopija[i][j-1] ^= 1;
	if (i < V-1) kopija[i+1][j] ^= 1;
	if (j < S-1) kopija[i][j+1] ^= 1;
}
 
void transponiraj() {
	for (int i = 0; i < max(V, S); i++) {
		for (int j = i+1; j < max(V, S); j++) {
			swap(mreza[i][j], mreza[j][i]);
			swap(zelja[i][j], zelja[j][i]);
		}
	}
	swap(V, S);
}
 
bool poskusi(int p) {
	kopiraj();
	for (int j = 0; j < S; j++) {
		if (p & (1 << j)) {
			flip(0, j);
		}
	}
	for (int i = 1; i < V; i++) {
		for (int j = 0; j < S; j++) {
			if (kopija[i-1][j] != zelja[i-1][j]) {
				flip(i, j);
			}
		}
	}
	for (int j = 0; j < S; j++) {
		if (kopija[V-1][j] != 0) return false;
	}
	return true;
}
 
void preveri() {
    bool obrnjeno = false;
    if (V < S) transponiraj();
    bool ok = false;
	for (int p = 0; p < (1 << S); p++) {
        if (poskusi()) {
            ok = true;
            break;
        }
	}

    if (obrnjeno) transponiraj();
    return ok;
}
