#include <stdio.h>

int main() {  // AltGr + B oz. N
	
	// Zanimalo nas bo, kako v računalniku delamo s
	// številkami. Torej, želimo vedeti, kako številke
	// shranimo, kako z njimi računamo in kako jih
	// prikažemo uporabnikom
	
	// Prvo vprašanje: Kako številke shranjujemo?
	// Odgovor: ustvarimo spremenljivko
	int mojaspremenljivka;
	// Zgornja koda deklarira spremenljivko z imenom
	// mojaspremenljivka, in ji nastavi tip števila (int) - integer
	
	// Ko je spremenljivka deklarirana, ji lahko nastvimo vrednost
	// ali računamo z njo.
	// mojaspremenljivka = 3;
	
	mojaspremenljivka = (-3 + 5) / 2 * 7;
	
	// Na voljo so nam osnovne računske operacije:
	// + za seštevanje
	// - za odštevanje
	// * za množenje (Shift + +)
	// / za deljenje
	
	// Pri odštevanju se nam lahko pojavijo tudi negativna števila.
	// To so števila, ki so manjša od nič. Dobimo jih tako, da odštejemo
	// večje število od manjšega, na primer 3-5.
	// Rezultat tega je -2, dobimo pa ga tako, da odštejemo manjše
	// število od večjega, nato pa rezultatu dopišemo še -
	// Za delo z negativnimi števili poznamo nekaj pravil:
	// -(-3) = 3
	// -4 = (-1) * 4
	// -3 + 3 = 0
	// -3 - 4 = -7
	
	// Množenje z negativnim številom:
	// 5 * (-4) = -20
	// (-5) * (-4) = 20
	
	// Deljenje z negativnimi števili:
	// (-6) / 3 = -2
	// (-5) / 3 = -1
	
	// POZOR!
	// Deljenje je na sploh komplicirano, sploh pa v programiranju
	// Pri nas (v C++) se bomo ukvarjali le s celoštevilskim
	// deljenjem - rezultat deljenja bo vedno število 0, 1, 2, ...
	// (nikoli decimalna števila)
	
	// Problem pri deljenju se pojavi, da ne moremo deliti vse
	// pare števil tako, da bi bil rezultat celo število.
	// Konvencija pravi, da je rezultat deljenja vedno navzdol
	// zaokrožena dejanska vrednost
	
	// Lahko pa še malo bolj zvito delamo z deljenjem:
	// Spomnimo se iz šole: 7 deljeno s 3 je 2, ostanek 1
	// Izračunati želimo torej še ostanek - za to imamo na voljo
	// poseben operator %
	
	// mojaspremenljivka = 7 % 3;  // izračuna ostanek pri deljenju
	
	// Ostanek je v praksi zelo uporabna operacija. Uporabimo jo
	// na primer vsakič, ko pogledamo na uro:
	// Primer. Če je sedaj ura 7, in nas zanima, koliko bo ura
	// čez 8 ur, izračunamo (7 + 8) % 12 = 3
	
	
	// Spodnje ni enačba, temveč samo ukaz, ki pač uporablja
	// mojaspremenljivka na obeh straneh.
	// Ukaz pomeni, da prvo izračunamo 1 + mojaspremenljivka,
	// potem pa rezultat shranimo v mojaspremenljivka
	mojaspremenljivka = 1 + mojaspremenljivka;
	
	// printf izpiše neko besedilo, lahko pa ima to besedilo
	// še formatnike - %(...) - ti formatniki povedo, da
	// bomo neke podatke še dodatno sporočili
	printf("Vrednost spremenljivke je: %d\n", mojaspremenljivka);
	// %d pomeni, da bomo sporočili še eno številko za izpis
	
	// Kar se zgodi je, da računalnik zamenja %d z vrednostjo
	// spremenljivke, ki smo jo podali v printf-u kot drugi argument
	
	/*
	// Lahko izpišemo tudi več števil hkrati:
	printf("Prvo stevilo je %d, drugo pa %d\n", 3, 7);
	*/
	
	return 0;
}

// % - Shift + 5
