#include <stdio.h>

void funkcija(int x) {
	if (x == 0) {
		printf("Zivjo\n");
	} else {
		funkcija(x-1);
		funkcija(x-1);
	}
}

int main() {
	
	// Prvo, kar nas zanima, je:
	// Kolikokrat bo naslednji program izpisal "Zivjo"?
	
	/*
	for (int i = 0; i < 10; i++) {
		printf("Zivjo\n");
	}
	
	// Mogoče pomaga, če to zapišemo na drug način:
	
	int i = 0;             // ena stvar
	while (i < 10) {       // enajstkrat se ponovi: preverimo i < 10
		printf("Zivjo");   // desetkrat izpišemo Zivjo
		i++;               // desetkrat povečamo i
	}
	
	// Skupaj:
	// 1 + 11 + 10 + 10 = 32
	*/
	
	/*
	int n;
	scanf("%d", &n);   // veliko več kot ena operacija!
	for (int i = 0; i < n; i++) {
		printf("Zivjo\n");
	}
	// Skupaj:
	// 1 + 1 + (1 + (n+1) + n + n) = 3*n + 4*1
	*/
	// O(n)
	
	/*
	int n, m;
	scanf("%d%d", &n, &m);
	for (int i = 0; i < n; i++) {
		for (int j = 0; j < m; j++) {
			printf("Zivjo\n");
		}
	}
	// Skupaj:
	// 1 + 1 + (1 + (n+1) + n + n*( 1 + (m+1) + m + m))
	// = 5 + 4*n + 3*n*m
	*/
	// 1 + n + n*m -> O(n*m)
	
	/*
	int n;
	scanf("%d", &n);
	funkcija(n);
	*/
	// ugotovili smo, da se Zivjo izpiše 2^n-krat.
	// O(2^n)
	
	/*
	int n;
	scanf("%d", &n);
	for (int i = 0; i < n; i++) {
		for (int j = i; j < n; j++) {
			printf("Zivjo\n");
		}
	}
	// Zivjo se izpiše n*(n+1)/2-krat
	// = (n^2 + n)/2
	// = n^2 / 2 + n/2
	// = n^2 / 2
	// = O(n^2)
	*/
	
	// Zdaj pa:
	// Naredimo to še enkrat, ampak namesto izpisovanja preštejmo,
	// koliko OPERACIJ je naredil računalnik
	
	// Videli smo, da kot število operacij dobimo nek izraz, odvisen
	// od vhodnih števil n oz. m
	// Konstantni faktorji (npr. 3 v izraz 3*n+4) niso natančni (niti
	// približno), ker ne vemo, kako težke so operacije v primerjavi
	// ena z drugo
	// Da se rešimo tega problema, te številke ignoriramo.
	// Namesto 3*n + 4 napišemo n+1.
	
	// Poleg tega bomo ignorirali vse seštevance, razen največjega
	// Npr. namesto n+1 tako dobimo n
	
	// Ko smo naredili ta postopek, končni rezultat zapišemo v
	// O(...)
	// Temu rečemo asimptotična notacija (big O notation)
	
	// Pri nas, drugi program je O(n)
	
	return 0;
}
