$(function(){

	function initPolje() {
		for (var i = 0; i < 9; i++)
			for (var j = 0; j < 12; j++)
				polje[i][j] = 0;
		
		$("td").removeClass();
	}

	var konecIgre = false;
	var igralec = 1;

	var polje = new Array(9);
	for (var i = 0; i < 9; i++) 
		polje[i] = new Array(12);
	
	initPolje();
	
	$("td").on("mouseover", t => {
		var col = $(t.target).index();

		if (polje[0+2][col+2] > 0 || konecIgre) return;
		
		$("thead").find("td").eq(col).addClass(logo());
						
		for (var s of $("tbody").children()) {
			$(s).children().eq(col).addClass("green");
		}
	});
	
	$("td").on("mouseout", t => {
		$("td").not(".final").removeClass();
		$("td").removeClass("green");
	} );
	
	$("td").on("click", t => {
		var col = $(t.target).index();
		
		if (polje[0+2][col+2] > 0 || konecIgre) return;
		
		var row;
		for (row = 1; row < 5; row++) {
			if (polje[row+2][col+2] > 0) break;
		}
		row--;
				
		polje[row+2][col+2] = igralec;
						
		var otroci = $("tbody").children();
		
		var i = 0;
		var anim = setInterval(s => {
			$("td").not(".final").removeClass();
			otroci.eq(i++).children().eq(col).addClass(logo());
			
			if (i > row) {
				clearInterval(anim);
				otroci.eq(i-1).children().eq(col).addClass("final");
				igralec = igralec == 1 ? 2 : 1;
				$(t.target).trigger("mouseout").trigger("mouseover");
				
				var konec = preveriKonec(col, row);
				if (konec > 0) {
					var r;
					if (konec == 3) {
						r = confirm("Igralca sta igrala remi. Želite ponovno igrati?");
					} else {
						r = confirm("Zmagal je " + $("#oseba"+konec).val() + ". Želite ponovno igrati?");
					}
					if (r) {
						initPolje();
						konecIgre = false;
					} else {
						konecIgre = true;
					}
				}
			}
					
		}, 50);
				
	});
	
	var logo = () => igralec == 1 ? "logo-rumen" : "logo-rdec";
			
	function preveriKonec(col, row) {
		col += 2;
		row += 2;
			
		for (var i = -2; i < 2; i++) {
			for (var j = -1; j < 2; j++) {
				if (polje[row+j][col+i] == polje[row][col] && polje[row][col] > 0 && (
				(polje[row+j][col+i] ==  polje[row-1+j][col-1+i] && polje[row+j][col+i] ==  polje[row+1+j][col+1+i]) ||
				(polje[row+j][col+i] ==  polje[row+1+j][col-1+i] && polje[row+j][col+i] ==  polje[row-1+j][col+1+i]) ||
				(polje[row+j][col+i] ==  polje[row+j][col-1+i] && polje[row+j][col+i] ==  polje[row+j][col+1+i])  ||
				(polje[row+j][col+i] ==  polje[row-1+j][col+i] && polje[row+j][col+i] ==  polje[row+1+j][col+i]) ))
					return polje[row][col];
			}
		}
			
		// preverimo se polno plosco za remi
		for (var i = 0; i < 8; i++) {
			if (polje[0+2][i+2] == 0) return 0;
		}
						
		return 3; // remi
	}
	
	$("#btnReset").on("click", t => {
		initPolje();
		konecIgre = false;
	});
});
