#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <assert.h>
#include <iostream>
#include <sstream>
#include <vector>
#include <string>
#include <math.h>
#include <queue>
#include <list>
#include <algorithm>
#include <map>
#include <set>
#include <stack>
#include <ctime>
using namespace std;

#define ALL(c) (c).begin(),(c).end()
#define IN(x,c) (find(c.begin(),c.end(),x) != (c).end())
#define REP(i,n) for (int i=0;i<(int)(n);i++)
#define FOR(i,a,b) for (int i=(a);i<=(b);i++)
#define INIT(a,v) memset(a,v,sizeof(a))
#define SORT_UNIQUE(c) (sort(c.begin(),c.end()), c.resize(distance(c.begin(),unique(c.begin(),c.end()))))
template<class A, class B> A cvt(B x) { stringstream ss; ss<<x; A y; ss>>y; return y; }

typedef pair<int,int> PII;
typedef long long int64;

int n;
int d[2000][2000];

struct edge {
	int a,b,c;
};

bool operator<(edge e1, edge e2) {
	return e1.c<e2.c;
}

int p[2000];

int root(int x) {
	if (p[x]==-1) return x;
	else return p[x]=root(p[x]);
}

int ok=1;
vector<int> t[2000];

void dfs(int x, int p, int x0, int c) {
	if (d[x0][x]!=c) ok=0;
	for (int y : t[x]) if (y!=p) {
		dfs(y,x,x0,c+d[x][y]);
	}
}

int main() {
	scanf("%d",&n);
	vector<edge> edges;
	REP (i,n) {
		REP (j,n) {
			scanf("%d",&d[i][j]);
			edges.push_back({i,j,d[i][j]});
		}
		p[i]=-1;
	}
	// basic
	REP (i,n) {
		REP (j,n) {
			if (d[i][j]!=d[j][i]) ok=0;
			if (i!=j && d[i][j]==0) ok=0;
		}
		if (d[i][i]!=0) ok=0;
	}
	// MST
	sort(ALL(edges));
	REP (i,edges.size()) {
		int a=edges[i].a, b=edges[i].b;
		int ra=root(a), rb=root(b);
		if (ra==rb) continue;
		t[a].push_back(b);
		t[b].push_back(a);
		p[rb]=ra;
	}
	// check
	REP (i,n) {
		dfs(i,-1,i,0);
	}
	if (ok) printf("YES\n");
	else printf("NO\n");
	return 0;
}
